--
-- Bank of Hagenstedt v1.012
--
-- @author  MX11
-- Ideas Royal Bank of LS from Neelson and Farming Shop Inventory Fixer from Decker
-- Thanks Agestar and rafftnix for the support!
--
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
--
-- @date  	08.12.2012
-- @history v0.9     04.11.2012 - Experimental test.
--          v0.91    06.11.2012 - Anpassung der GUI auf aenderbare Kreditsumme.
--          v0.92    07.11.2012 - Kreditlaufzeit und Ueberziehungszins.
--          v0.93	 08.11.2012 - Input gefixt, weitere Texte in modDesc ausgelagert. Speichern der Daten beim Speichern des Spielstands.
--          v0.94    09.11.2012	- Kreditsystem kompatiel mit org. Kredit gemacht und Kreditbetrag nur ab 10000er Stelle nderbar.
--          v0.95    10.11.2012	- Kredit hinzufgen und entfernen in 5000er Schritten zustzlich hinzugefgt.
--                   11.11.2012 - Buttons neu angeordnet. Laden der Kreditdaten nur bei einem bestehenden Spiel.
--          v0.96    12.11.2012 - Fehler speichern der Bankdaten beim Beenden der Map ohne speichern beseitigt.
--                   14.11.2012 - addHelpButtonText und addWarning gefixt. addWarning nur wenn GUI nicht aktiv.
--          v1.00    16.11.2012 - Release zum Testteam des off. Forums.
--          v1.01    08.12.2012 - Fix bei bestehendem Savegame ohne xml Datei.
--          v1.011   27.12.2012 - self.debug wieder in bankofhagenstedt.debug gendert, da in der Funktion update ein Zugriffproblem bestand.
--          v1.012   04.01.2013 - Versionsnummer wurde nach dem auslesen aus der XML mit Nachkommastellen versehen, nun wird auf 3 Stellen gerundet.
--                                Wenn Autosave verwendet wird, erscheint natrlich die Meldung "Kreditdaten gespeichert".


bankofhagenstedt = {};
--MOD DATA
bankofhagenstedt.debug = false;
bankofhagenstedt.modDir = g_modsDirectory.."/bankofhagenstedt/";
bankofhagenstedt.scriptName = "bankofhagenstedt";
bankofhagenstedt.version = 1.012;
bankofhagenstedt.savegamePath = getUserProfileAppPath() .. "savegame" .. g_careerScreen.selectedIndex;
bankofhagenstedt.savegameFilename = bankofhagenstedt.savegamePath .. "/" .. bankofhagenstedt.scriptName ..".xml";
bankofhagenstedt.fileFound = false;
bankofhagenstedt.showWarning = false;
--BANK DATA
bankofhagenstedt.loanInterestCalculationDays = 360;
bankofhagenstedt.loanInterestRate = 0.44;
bankofhagenstedt.loanInterestRateLeicht = 0.44;
bankofhagenstedt.loanInterestRateNormal = 0.45;
bankofhagenstedt.loanInterestRateSchwer = 0.46;
bankofhagenstedt.giantsLoanInterestCalculationDays = 35600.56169775123; --Aus dem Spiel ermittelt.
bankofhagenstedt.giantsLoanInterval = 5000;
bankofhagenstedt.loanValue = 100000;
bankofhagenstedt.loanFees = 0;
bankofhagenstedt.loanPeriod = 0;
bankofhagenstedt.loanOverdraftDays = 0;
bankofhagenstedt.loanOverdraftInterest = 0;
-- BEFORE LOAN DATA
bankofhagenstedt.beforeLoanValue = 0;
bankofhagenstedt.beforeLoanMax = 0;
bankofhagenstedt.beforeLoanInterestRate = 0;
-- ACTIVE LOAN DATA
bankofhagenstedt.loanActive = false;
bankofhagenstedt.activeLoanValue = 0;
bankofhagenstedt.activeLoanDays = 0;
bankofhagenstedt.activeLoanPeriod = 0;
bankofhagenstedt.activeLoanInterestOwed = 0;
bankofhagenstedt.activeLoanOverdraftDays = 0;
bankofhagenstedt.activeLoanOverdraftInterest = 0;
--GUI DATA
bankofhagenstedt.scale = 0.65;
bankofhagenstedt.offsetX = 0.010;
bankofhagenstedt.offsetY = 0.340;
bankofhagenstedt.MouseButton_Left          = 0x01;
bankofhagenstedt.MouseButton_Right         = 0x02;
bankofhagenstedt.MouseButton_Middle        = 0x04;
bankofhagenstedt.MouseButton_ScrollUp      = 0x08;
bankofhagenstedt.MouseButton_ScrollDown    = 0x10;
bankofhagenstedt.MouseButton_Scroll        = bitOR(bankofhagenstedt.MouseButton_ScrollUp, bankofhagenstedt.MouseButton_ScrollDown);

print("Script loaded: bankofhagenstedt v"..bankofhagenstedt.version.. " - " .. g_i18n:getText("BOH_COPYRIGHT"));

function bankofhagenstedt:loadMap(name)
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - loadMap(name)");
	end;

    -- Only initialize once, and not at every .I3D file loaded.
    if (self.initialized) then
        return;
    end;

	self.isDisplayModLoaded = true;
	self.displayOn = false;
	
	self:setInterestRate();
	self:setCreditPeriod();

    self.overlayButtons = {};
	self.overlayDesktop = Overlay:new("bankofhagenstedtBackground",  bankofhagenstedt.modDir .. "bank_background.dds",   sox(0.000),soy(0.000), s(1.000),s(1.000));
	self.addLoanButton = self:addButton(g_i18n:getText("BOH_ADDLOAN"),   "dataS2/menu/button_normal.png",   bankofhagenstedt.addLoan, nil, sox(0.010),soy(0.140), s(0.300),s(0.065));
	self.removeLoanButton = self:addButton(g_i18n:getText("BOH_REMOVELOAN"),   "dataS2/menu/button_normal.png",   bankofhagenstedt.removeLoan, nil, sox(0.010),soy(0.090), s(0.300),s(0.065));
	self.addFiveThousandButton = self:addButton(g_i18n:getText("BOH_ADDFIVETHOUSAND"),   "dataS2/menu/button_normal.png",   bankofhagenstedt.addFiveThousand, nil, sox(0.540),soy(0.140), s(0.300),s(0.065));
	self.removeFiveThousandButton = self:addButton(g_i18n:getText("BOH_REMOVEFIVETHOUSAND"),   "dataS2/menu/button_normal.png",   bankofhagenstedt.removeFiveThousand, nil, sox(0.540),soy(0.090), s(0.300),s(0.065));
    --
    -- loan arrow buttons/hotspots
    self.digits = {};
    self.digits.offsetW = 0.035;
    self.digits.offsetH = 0.035;
    self.digits.x = 0.450;
    self.digits.y = 0.360;
    self.digits.textSize = 0.040;
    self:addButton(nil, "dataS2/menu/text_input_bg_normal.png",  nil, nil, sox(self.digits.x-0.295+(self.digits.offsetW*1.25)),soy(self.digits.y-0.01), s(0.330),s(0.07));
    local digitArrows = Utils.getFilename("DigitArrows.dds", bankofhagenstedt.modDir);
	-- von 0 auf 3
    for idx=3,6 do
        local power = math.pow(10,idx);
        self:addHotspot(digitArrows, self.onLoanModify,  power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y - (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH*3), bankofhagenstedt.MouseButton_ScrollUp);
        self:addHotspot(nil,         self.onLoanModify, -power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y - (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH*3), bankofhagenstedt.MouseButton_ScrollDown);
        self:addButton(nil, nil, bankofhagenstedt.onLoanModify,  power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y + (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH));
        self:addButton(nil, nil, bankofhagenstedt.onLoanModify, -power, sox(self.digits.x - (self.digits.offsetW * idx)), soy(self.digits.y - (self.digits.offsetH)), s(self.digits.offsetW),s(self.digits.offsetH));
    end;
	
    self.guiOn = false;
    self.overlayIcon = nil;
    self:setInfo("");
    self.firstTime = true;
    --
    self.initialized = true;
	
end;
function bankofhagenstedt:deleteMap()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - bankofhagenstedt:deleteMap()");
	end;

    -- Clean up resources
    delete(self.overlayDesktop); self.overlayDesktop = nil;
    for _,b in pairs(self.overlayButtons) do
        if (b.overlayUnchecked ~= nil) then
            delete(b.overlayUnchecked);
            delete(b.overlayChecked);
        else
            if (b.overlay ~= nil) then
                delete(b.overlay);
            end;
        end;
    end;
    self.overlayButtons = {};
    --
    self.initialized = false;
end;
function bankofhagenstedt:delete()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - bankofhagenstedt:delete()");
	end;
end;
--Save BANKDATA to XML by saving the game
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame; -- add Save Callback
CareerScreen.saveSelectedGame = function(self)
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - CareerScreenSaveSelectedGame()");
	end;
	CareerScreenSaveSelectedGame(self); 
	bankofhagenstedt:saveBankData();
end;
function bankofhagenstedt:mouseEvent(posX, posY, isDown, isUp, button)
    if (self.guiOn) then
--DEBUG.start
--      if (posX < 0.2 and posY < 0.2) then
--          print(string.format("X/Y=%.3f/%.3f, down/up=%s/%s, but=%2d", posX,posY, tostring(isDown),tostring(isUp), button));
--      end;
--DEBUG.end
        if (isDown) then
            -- Convert mouse-button to other value, so it can be AND-masked.
            if      (button == 1) then button = bankofhagenstedt.MouseButton_Left; 
            elseif  (button == 2) then button = bankofhagenstedt.MouseButton_Right;
            elseif  (button == 3) then button = bankofhagenstedt.MouseButton_Middle;
            elseif  (button == 4) then button = bankofhagenstedt.MouseButton_ScrollUp;
            elseif  (button == 5) then button = bankofhagenstedt.MouseButton_ScrollDown;
            end;
            --
            for _,overlayButton in pairs(self.overlayButtons) do
                if (overlayButton.enabled) then
                    if (overlayButton.rect[1] <= posX and posX <= overlayButton.rect[3] and overlayButton.rect[2] <= posY and posY <= overlayButton.rect[4]) then
                        if (bitAND(overlayButton.mouseButtons, button) > 0 and overlayButton.onClick ~= nil) then
                            overlayButton.onClick(self, overlayButton.callbackData);
                            break;
                        end;
                    end;
                end;
            end;
        end;
    end;
end;
function bankofhagenstedt:keyEvent(unicode, sym, modifier, isDown)
end;
function bankofhagenstedt:update(dt)
    -- Meldungen anzeigen fr eine gewisse Zeit
    if (self.displayTimer > 0) then
        self.displayTimer = self.displayTimer - dt;
		--Wenn Warnung dann ingame ausgeben.
		if (self.showWarning and (not self.guiOn)) then
			g_currentMission:addWarning(self.displayMsg, 0.07+0.022, 0.019+0.029);	
		end;
	else
		self.showWarning = false;	
    end;

    -- Handle "autoload at map-start"
    if (self.firstTime) then
        self:loadBankData(self.firstTime);
        self.firstTime = false; -- Set to false, _before_ executing load, so if something fails here on after, we do not go into an endless-fail-loop.
    end;
    
    --
	if (InputBinding.hasEvent(InputBinding.INPUT_TOGGLELAPTOP) and Input.isKeyPressed(Input.KEY_lalt)) then
		self:setGuiOn(not self.guiOn);
		InputBinding.setShowMouseCursor(self.guiOn);
	end;

    --      
    if (self.guiOn) then
        -- If player activates some GUI screen.
        if (g_gui.currentGuiName ~= "" and g_gui.currentGuiName ~= nil) then
            self:setGuiOn(false);
            -- Do not disable mousecursor here, due to the player might enter the real Farming Shop (Key P), and expects the mousecursor to be visible.
        end;
	else
		-- Only add help-texts when the help-box is visible. If not, the array 'g_currentMission.helpButtonTexts' will just grow-and-grow-and...(bad allocation?)
		-- Also this should reduce (for this mod) the "big helpbox huge-to-less flashing", when turning the helpbox on again with key F1.
		if g_currentMission.showHelpText then
			g_currentMission:addHelpButtonText(g_i18n:getText("BOH_TOGGLELAPTOP"), InputBinding.INPUT_TOGGLELAPTOP);
		end;
    end;
	--Bank functionality - Interests
	--Zinsen werden vom Spiel direkt berechnet und abgezogen.
	if g_currentMission.environment.currentDay ~= self.lastday then
		self:setInterestRate();
		if(bankofhagenstedt.loanActive) then
			if(bankofhagenstedt.debug) then
				print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate:" .. g_currentMission.missionStats.loanAnnualInterestRate);
				print("Bankofhagenstedt - DEBUG - loanMax:" .. g_currentMission.missionStats.loanMax);
				print("Bankofhagenstedt - DEBUG - loan:" .. g_currentMission.missionStats.loan);
				print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate:" .. g_currentMission.missionStats.loanAnnualInterestRate);
			end;
			self.zinsbetrag = bankofhagenstedt:getCurrentInterestAmount();
			bankofhagenstedt.activeLoanInterestOwed=bankofhagenstedt.activeLoanInterestOwed+self.zinsbetrag;
			bankofhagenstedt.activeLoanDays = bankofhagenstedt.activeLoanDays + 1;
		end;
		self.lastday = g_currentMission.environment.currentDay;
		if self.firstRun then
			if self.lastMoney ~= g_currentMission.missionStats.money then
				g_currentMission.missionStats.money = self.lastMoney;
			end;
			self.firstRun = false;				
		end;
	end;
	self:checkButtons();
	--Map Autosave auf 10 min
	--g_currentMission.missionDynamicInfo.autoSave=true;
    --g_currentMission.autoSaveInterval=600000 ;
end;
function bankofhagenstedt:draw()
    if (self.guiOn) then
        InputBinding.setShowMouseCursor(self.guiOn); -- Test. Will this stop movement of camera, if its called at every draw()?
                                                     -- Yeah, it did... Weird. Though still no luck when ONFOOT.

        self.overlayDesktop:render();
        self:renderButtons();

        setTextAlignment(RenderText.ALIGN_CENTER);
        renderTextWithShade(sox(0.500),soy(0.92), s(0.06), g_i18n:getText("BOH_TITLE"));
        if (self.displayTimer > 0) then
            renderText(sox(0.500),soy(0.020), s(0.03), self.displayMsg);
        end;		
        setTextAlignment(RenderText.ALIGN_LEFT);       
        renderTextWithShade(sox(0.010),soy(0.770), s(0.04), g_i18n:getText("BOH_MONEY") .. ': ' .. string.format("%.0f",Utils.getNoNil(g_currentMission.missionStats.money, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));
        renderTextWithShade(sox(0.540),soy(0.770), s(0.04), g_i18n:getText("BOH_BANKLINE") .. ': ' .. string.format("%.0f",Utils.getNoNil(g_currentMission.missionStats.loanMax, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));
        renderTextWithShade(sox(0.010),soy(0.710), s(0.04), g_i18n:getText("BOH_LOAN") .. ': ' .. string.format("%.0f",Utils.getNoNil(g_currentMission.missionStats.loan, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));
		renderTextWithShade(sox(0.540),soy(0.710), s(0.04), g_i18n:getText("BOH_LOANVALUE") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.activeLoanValue, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));
        renderTextWithShade(sox(0.010),soy(0.650), s(0.04), g_i18n:getText("BOH_BASERATE") .. ': ' .. string.format("%.0f",math.ceil(Utils.getNoNil(g_currentMission.missionStats.loanAnnualInterestRate, 0)/bankofhagenstedt.loanInterestCalculationDays)) ..' '.. g_i18n:getText("BOH_PERCENT"));
		renderTextWithShade(sox(0.540),soy(0.650), s(0.04), g_i18n:getText("BOH_INTERESTSUM") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.activeLoanInterestOwed, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));
        renderTextWithShade(sox(0.010),soy(0.590), s(0.04), g_i18n:getText("BOH_LIFEOFALOAN") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.activeLoanPeriod, 0)) ..' '.. g_i18n:getText("BOH_DAYS"));
        renderTextWithShade(sox(0.540),soy(0.590), s(0.04), g_i18n:getText("BOH_LOANACTIVESINCE") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.activeLoanDays, 0)) ..' '.. g_i18n:getText("BOH_DAYS"));
        renderTextWithShade(sox(0.010),soy(0.530), s(0.04), g_i18n:getText("BOH_OVERDRAFTPERIOD") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.activeLoanOverdraftDays, 0)) ..' '.. g_i18n:getText("BOH_DAYS"));
        renderTextWithShade(sox(0.540),soy(0.530), s(0.04), g_i18n:getText("BOH_OVERDRAFTINTERST") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.activeLoanOverdraftInterest, 0)) ..' '.. g_i18n:getText("BOH_PERCENT"));
		--Daten fuer den aufzunehmenden Kredit
        renderTextWithShade(sox(0.010),soy(0.225), s(0.04), g_i18n:getText("BOH_BASERATE") .. ': ' .. string.format("%.0f",math.ceil(Utils.getNoNil(bankofhagenstedt.loanInterestRate, 0)/bankofhagenstedt.loanInterestCalculationDays)) ..' '.. g_i18n:getText("BOH_PERCENT"));
        renderTextWithShade(sox(0.540),soy(0.225), s(0.04), g_i18n:getText("BOH_LIFEOFALOAN") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.loanPeriod, 0)) ..' '.. g_i18n:getText("BOH_DAYS"));
		renderTextWithShade(sox(0.010),soy(0.280), s(0.04), g_i18n:getText("BOH_LOANVALUE") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.loanValue, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));
		renderTextWithShade(sox(0.540),soy(0.280), s(0.04), g_i18n:getText("BOH_LOANFEES") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.loanFees, 0)) ..' '.. g_i18n:getText("BOH_CURRENCY"));		
		renderTextWithShade(sox(0.010),soy(0.3675), s(0.04), g_i18n:getText("BOH_LOANAMOUNT") .. ': '); 	
		renderTextWithShade(sox(0.490),soy(0.3675), s(0.04), g_i18n:getText("BOH_CURRENCY")); 	
        setTextAlignment(RenderText.ALIGN_RIGHT);       
        local loanHighTxt = string.format("%10d", bankofhagenstedt.loanValue);
        for idx=0,7 do
            renderText(sox((self.digits.x+0.02) - (self.digits.offsetW*idx)), soy(self.digits.y+0.0075), s(self.digits.textSize), string.sub(loanHighTxt, 10-idx, 10-idx));
        end;
        setTextAlignment(RenderText.ALIGN_LEFT);       
		renderTextWithShade(sox(0.540),soy(0.380), s(0.04), g_i18n:getText("BOH_OVERDRAFTPERIOD") .. ': ' .. string.format("%.0f",Utils.getNoNil(bankofhagenstedt.loanOverdraftDays, 0)) ..' '.. g_i18n:getText("BOH_DAYS"));
        renderTextWithShade(sox(0.540),soy(0.330), s(0.04), g_i18n:getText("BOH_OVERDRAFTINTERST") .. ': ' .. string.format("%.0f",math.ceil(Utils.getNoNil(bankofhagenstedt.loanOverdraftInterest, 0))) ..' '.. g_i18n:getText("BOH_PERCENT"));
		renderText(sox(0.010), soy(0.045), s(0.025), "V "..bankofhagenstedt.version);
		renderText(sox(0.010), soy(0.015), s(0.025), g_i18n:getText("BOH_COPYRIGHT"));
		if(bankofhagenstedt.debug) then
			setTextColor(1.0,0.0,0.0, 0.8);
			renderText(sox(0.010), soy(0.85), s(0.025), "Developer Edition");

		end;
	end;	
end;
function bankofhagenstedt:setGuiOn(yesno)
    self.guiOn = yesno;
    g_mouseControlsHelp.active = not self.guiOn;
    --InputBinding.setShowMouseCursor(self.guiOn);
    -- if (self.guiOn) then
        -- g_gui:showGui(self.guiName);
    -- else
        -- g_gui:showGui("");
    -- end;
end;
function bankofhagenstedt:addHotspot(imgFilename, callback, callbackData, x,y, width,height, mouseButtons)
    local overlay = nil;
    if (imgFilename ~= nil) then
        overlay = Overlay:new(nil, imgFilename, x,y, width,height);
    end;
    local button = {visible=(overlay ~= nil), enabled=true, buttonText=nil, overlay=overlay, rect={x,y, x+width,y+height}, onClick=callback, callbackData=callbackData, mouseButtons=mouseButtons};
    table.insert(self.overlayButtons, button);
end;
function bankofhagenstedt:addButton(buttonText, imgFilename, callback, callbackData, x,y, width,height, mouseButtons)
    if (mouseButtons == nil) then mouseButtons = bankofhagenstedt.MouseButton_Left; end;
    local overlay = nil;
    if (imgFilename ~= nil) then
        overlay = Overlay:new(buttonText, imgFilename, x,y, width,height);
    end;
    local button = {visible=(overlay ~= nil), enabled=true, buttonText=buttonText, overlay=overlay, rect={x,y, x+width,y+height}, onClick=callback, callbackData=callbackData, mouseButtons=mouseButtons};
    table.insert(self.overlayButtons, button);
    return button;
end;
function bankofhagenstedt:renderButtons()
    setTextAlignment(RenderText.ALIGN_LEFT);
    setTextBold(true);

    for _,button in pairs(self.overlayButtons) do
        if (button.visible) then
            -- TODO - Normal, Focus, Pressed
            if (button.overlay ~= nil) then
                button.overlay:render();
            end;
            if (button.buttonText ~= nil) then
                if (button.enabled) then
                    setTextColor(0.0, 0.0, 0.0, 1.0);   -- black
					--s0.042
                    renderText(button.rect[1]+s(0.020), button.rect[2]+s(0.013), s(0.028), button.buttonText);
                    setTextColor(1.0, 1.0, 1.0, 1.0);   -- white
                else
                    setTextColor(1.0, 1.0, 1.0, 0.3);   -- gray'ish
                end;
                renderText(button.rect[1]+s(0.020), button.rect[2]+s(0.017), s(0.028), button.buttonText);
            end;
        end;
    end;
end;
function s(z)
-- Scale
    return z * bankofhagenstedt.scale;
end;
function sox(x)
    -- Scale & Offset X
	return s(x)+bankofhagenstedt.offsetX;
end;
function soy(y)
-- Scale & Offset Y
    return s(y)+bankofhagenstedt.offsetY;
end;    
function renderTextWithShade(x,y, textSize, text)
    setTextColor(0.0, 0.0, 0.0, 1.0);   -- black
    renderText(x, y - (textSize/10), textSize, text);
    setTextColor(1.0, 1.0, 1.0, 1.0);   -- white
    renderText(x, y, textSize, text);
end;
function bankofhagenstedt:setInfo(msg)
    self.displayMsg = msg;
    self.displayTimer = 5000;
end;
function bankofhagenstedt:setWarning(msg, timer)
    self.displayMsg = msg;
    if (timer == nil) then
        timer = 5000;
    end;
    self.displayTimer = timer;
	self.showWarning = true;
end;
function bankofhagenstedt:onLoanModify(power)
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - onLoanModify(".. Utils.getNoNil(power,"nil") ..")");
	end;
    local loanHigh = bankofhagenstedt.loanValue;
    --
    if (power < 0 and loanHigh < math.abs(power)) then power = 0; end; -- If subtracting, do not subtract more than needed.
    loanHigh = loanHigh+power;
    if (loanHigh > 9999999) then loanHigh = 10000000; end; -- Nine million nine hundred ninety nine thousand nine hundred ninety nine... must be enough (or?)
    if (loanHigh < 1) then loanHigh = 10000; end; -- Zero or Negative loanHighs are not allowed!
    --
    bankofhagenstedt.loanValue = loanHigh;
	self:setInterestRate();
	self:setCreditPeriod();
end;
function bankofhagenstedt:setCreditPeriod()
	--Kreditgebhren
	bankofhagenstedt.loanFees = bankofhagenstedt.loanValue * (g_currentMission.missionStats.difficulty * 0.01);
	--Kreditsumme 	Laufzeit in Tagen 	Ueberziehungszeit in Tagen 	Strafzins (zusaetzlich)
	--            200.000   	7 	2 	10%
	--            500.000   	12 	2 	10%
	--         1.000.000   	20 	4 	15%
	--         2.000.000   	30 	5 	20%
	--         5.000.000   	40 	5 	30%	
	local loanBorder1 = 200000;
	local loanPeriod1 = 227;
	local loanOverdraftPeriod1 = 1;
	local loanPenaltyRate1 = 0.44; 
	local loanBorder2 = 500000;
	local loanPeriod2 = 227;
	local loanOverdraftPeriod2 = 1;
	local loanPenaltyRate2 = 0.45; 
	local loanBorder3 = 1000000;
	local loanPeriod3 = 227;
	local loanOverdraftPeriod3 = 1;
	local loanPenaltyRate3 = 0.46; 
	local loanBorder4 = 2000000;
	local loanPeriod4 = 227;
	local loanOverdraftPeriod4 = 1;
	local loanPenaltyRate4 = 0.47; 
	local loanBorder5 = 5000000;
	local loanPeriod5 = 227;
	local loanOverdraftPeriod5 = 1;
	local loanPenaltyRate5 = 0.48; 

	if(bankofhagenstedt.loanValue<loanBorder1) then
		bankofhagenstedt.loanPeriod = loanPeriod1;
		bankofhagenstedt.loanOverdraftDays = loanOverdraftPeriod1;
		bankofhagenstedt.loanOverdraftInterest = loanPenaltyRate1;
		elseif(bankofhagenstedt.loanValue>loanBorder1 and bankofhagenstedt.loanValue<loanBorder2) then
			bankofhagenstedt.loanPeriod = loanPeriod2;
			bankofhagenstedt.loanOverdraftDays = loanOverdraftPeriod2;
			bankofhagenstedt.loanOverdraftInterest = loanPenaltyRate2;
			elseif(bankofhagenstedt.loanValue>loanBorder2 and bankofhagenstedt.loanValue<loanBorder3) then
				bankofhagenstedt.loanPeriod = loanPeriod3;
				bankofhagenstedt.loanOverdraftDays = loanOverdraftPeriod3;
				bankofhagenstedt.loanOverdraftInterest = loanPenaltyRate3;	
				elseif(bankofhagenstedt.loanValue>loanBorder3 and bankofhagenstedt.loanValue<loanBorder4) then
					bankofhagenstedt.loanPeriod = loanPeriod4;
					bankofhagenstedt.loanOverdraftDays = loanOverdraftPeriod4;
					bankofhagenstedt.loanOverdraftInterest = loanPenaltyRate4;
					elseif(bankofhagenstedt.loanValue>loanBorder4) then
						bankofhagenstedt.loanPeriod = loanPeriod5;
						bankofhagenstedt.loanOverdraftDays = loanOverdraftPeriod5;
						bankofhagenstedt.loanOverdraftInterest = loanPenaltyRate5;	
	end;
end;
function bankofhagenstedt:addLoan(data)
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - addLoan()");
		--Hinzufuegen des Kredits
		print("Bankofhagenstedt - DEBUG - activeLoanValue:" .. bankofhagenstedt.activeLoanValue);
		print("Bankofhagenstedt - DEBUG - loanMax:" .. g_currentMission.missionStats.loanMax);
		print("Bankofhagenstedt - DEBUG - loan:" .. g_currentMission.missionStats.loan);
		print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate:" .. g_currentMission.missionStats.loanAnnualInterestRate);
	end;
	--Vor der Aufnahme des neuen Kredits die ursprnglichen Werte sichern
	bankofhagenstedt.beforeLoanValue = g_currentMission.missionStats.loan;
	bankofhagenstedt.beforeLoanMax = g_currentMission.missionStats.loanMax;
	bankofhagenstedt.beforeLoanInterestRate = g_currentMission.missionStats.loanAnnualInterestRate;
	--Hinzufgen des Kredits
	g_currentMission:addSharedMoney(bankofhagenstedt.loanValue);
	--Kreditgebhren werden direkt abgezogen
	g_currentMission:addSharedMoney(-bankofhagenstedt.loanFees);
	--Speicherung des aktiven Kredits
	bankofhagenstedt.activeLoanValue = bankofhagenstedt.loanValue;
	bankofhagenstedt.activeLoanPeriod = bankofhagenstedt.loanPeriod;
	bankofhagenstedt.activeLoanOverdraftDays = bankofhagenstedt.loanOverdraftDays;
	bankofhagenstedt.activeLoanOverdraftInterest = bankofhagenstedt.loanOverdraftInterest;
	g_currentMission.missionStats.loanMax = g_currentMission.missionStats.loanMax + bankofhagenstedt.loanValue;
	g_currentMission.missionStats.loan = g_currentMission.missionStats.loan + bankofhagenstedt.loanValue;
	bankofhagenstedt.loanActive = true;
	self:checkButtons();
	self:setInterestRate();
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - activeLoanValue:" .. bankofhagenstedt.activeLoanValue);
		print("Bankofhagenstedt - DEBUG - loanMax:" .. g_currentMission.missionStats.loanMax);
		print("Bankofhagenstedt - DEBUG - loan:" .. g_currentMission.missionStats.loan);
		print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate:" .. g_currentMission.missionStats.loanAnnualInterestRate);
	end;
	self.firstRun = false;
	self.lastday = g_currentMission.environment.currentDay;	
	self:setInfo(g_i18n:getText("BOH_LOANBORROW"));	
end;
function bankofhagenstedt:removeLoan(data)
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - removeLoan()");
	end;
	--Entfernen des Kredits
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - activeLoanValue:" .. bankofhagenstedt.activeLoanValue);
	end;
	if(bankofhagenstedt.activeLoanValue>g_currentMission.missionStats.money) then
		print(g_i18n:getText("BOH_LOANREPAYNOTPOSSIBLE"));
		self:setInfo(g_i18n:getText("BOH_LOANREPAYNOTPOSSIBLE"));
	else
		if(g_currentMission.missionStats.loan>=bankofhagenstedt.activeLoanValue) then
			--Aktiver Kredit ist kleiner oder gleich Gesamtkredit --> Lse aktiven ab!
			g_currentMission:addSharedMoney(-bankofhagenstedt.activeLoanValue);
			g_currentMission.missionStats.loan = g_currentMission.missionStats.loan - bankofhagenstedt.activeLoanValue;
			self:resetLoan();
			self:checkButtons();
			if(bankofhagenstedt.debug) then
				print("Bankofhagenstedt - DEBUG - activeLoanValue:" .. bankofhagenstedt.activeLoanValue);
				print("Bankofhagenstedt - DEBUG - loanMax:" .. g_currentMission.missionStats.loanMax);
				print("Bankofhagenstedt - DEBUG - loan:" .. g_currentMission.missionStats.loan);
				print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate:" .. g_currentMission.missionStats.loanAnnualInterestRate);
			end;
		else
			-- kann nicht vorkommen!
			if(bankofhagenstedt.debug) then
				print(g_i18n:getText("BOH_LOANAMOUNTTOLOW"));
				print("Bankofhagenstedt - DEBUG - activeLoanValue:" .. bankofhagenstedt.activeLoanValue);
			end;
			self:setWarning(g_i18n:getText("BOH_LOANAMOUNTTOLOW"),1000);
		end;
	end;
end;
function bankofhagenstedt:resetLoan()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - resetLoan()");
	end;
	self:setInfo(g_i18n:getText("BOH_LOANREPAYED"));
	bankofhagenstedt.loanActive = false;
	bankofhagenstedt.activeLoanValue = 0;
	bankofhagenstedt.activeLoanDays = 0;
	g_currentMission.missionStats.loanMax = bankofhagenstedt.beforeLoanMax;
	self:setInterestRate();
	self.removeLoanButton.enabled = false;
	self.addLoanButton.enabled = true;
end;
function bankofhagenstedt:setInterestRate()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - setInterestRate()");
	end;

	if g_currentMission.missionStats.difficulty == 1 then
		 bankofhagenstedt.loanInterestRate = (bankofhagenstedt.loanInterestRateLeicht * bankofhagenstedt.loanInterestCalculationDays);
	else
		if g_currentMission.missionStats.difficulty == 2 then
			bankofhagenstedt.loanInterestRate = (bankofhagenstedt.loanInterestRateNormal * bankofhagenstedt.loanInterestCalculationDays);
		else
			bankofhagenstedt.loanInterestRate = (bankofhagenstedt.loanInterestRateSchwer * bankofhagenstedt.loanInterestCalculationDays);
		end;
	end;
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate befor:" .. g_currentMission.missionStats.loanAnnualInterestRate);
	end;
	--Wenn Kredit ueberhaupt aufgenommen
	if (bankofhagenstedt.loanActive) then
		g_currentMission.missionStats.loanAnnualInterestRate = bankofhagenstedt.loanInterestRate;
		--Wenn Kredit ueberzogen
			if(bankofhagenstedt.activeLoanDays >= bankofhagenstedt.activeLoanPeriod) then
				--Kredit ueberzogen
				self:setWarning(g_i18n:getText("BOH_LIFEOFALOANEXPIRED"));
				if(bankofhagenstedt.activeLoanDays >= (bankofhagenstedt.activeLoanPeriod + bankofhagenstedt.activeLoanOverdraftDays)) then
					--Kredit ueberzogen und Strafzins
					self:setWarning(g_i18n:getText("BOH_LIFEOFALOANEXPIREDPENALTY"));
					g_currentMission.missionStats.loanAnnualInterestRate = bankofhagenstedt.loanInterestRate + (bankofhagenstedt.activeLoanOverdraftInterest * bankofhagenstedt.loanInterestCalculationDays);
				end;
			end;
	else
		g_currentMission.missionStats.loanAnnualInterestRate = bankofhagenstedt.beforeLoanInterestRate;		
	end;
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate after:" .. g_currentMission.missionStats.loanAnnualInterestRate);			
	end;	
end;
function bankofhagenstedt:checkLoanConsistency()
	--Prfen ob der Kredit ggf. von ber die Standardbank zurckbezahlt wurde.
	--Wenn Kredit < active und before Kredit, dann wurde was zurck bezahlt
	if(bankofhagenstedt.loanActive) then
		if(g_currentMission.missionStats.loan<(bankofhagenstedt.activeLoanValue+bankofhagenstedt.beforeLoanValue)) then
			--Es wurde was zurck bezahlt!
			local actualLoan = g_currentMission.missionStats.loan-bankofhagenstedt.beforeLoanValue;
			if(bankofhagenstedt.debug) then
				print("Bankofhagenstedt - DEBUG - checkLoanConsistency()");
				print("Bankofhagenstedt - DEBUG - bankofhagenstedt.activeLoanValue:"..bankofhagenstedt.activeLoanValue);
				print("Bankofhagenstedt - DEBUG - bankofhagenstedt.beforeLoanValue:"..bankofhagenstedt.beforeLoanValue);
				print("Bankofhagenstedt - DEBUG - g_currentMission.missionStats.loan:"..g_currentMission.missionStats.loan);
				print("Bankofhagenstedt - DEBUG - actualLoan:"..actualLoan);
			end;		
			if(actualLoan<bankofhagenstedt.activeLoanValue) then
			-- ...wurde etwas vom aktiven Kredit getilgt.
				if(bankofhagenstedt.activeLoanValue-actualLoan<0) then
					-- ... wurde mehr der aktive Kredit getilgt
					self:resetLoan();
				else
					-- ... wurde nur der aktive Kredit getilgt
					bankofhagenstedt.activeLoanValue = actualLoan;
					if(bankofhagenstedt.activeLoanValue<=0) then
						self:resetLoan();
					end;
				end;
			end;
			if(bankofhagenstedt.debug) then
				print("Bankofhagenstedt - DEBUG - after checkLoanConsistency()");
				print("Bankofhagenstedt - DEBUG - bankofhagenstedt.activeLoanValue:"..bankofhagenstedt.activeLoanValue);
				print("Bankofhagenstedt - DEBUG - bankofhagenstedt.beforeLoanValue:"..bankofhagenstedt.beforeLoanValue);
				print("Bankofhagenstedt - DEBUG - g_currentMission.missionStats.loan:"..g_currentMission.missionStats.loan);
			end;		
		end;
	end;
end;
function bankofhagenstedt:checkButtons()
	--Wenn Kredit aktiv
	if(bankofhagenstedt.loanActive) then
		bankofhagenstedt.checkLoanConsistency();
		bankofhagenstedt.addLoanButton.enabled = false;
		bankofhagenstedt.removeLoanButton.enabled = true;
		if(bankofhagenstedt.activeLoanValue<=g_currentMission.missionStats.money) then
			bankofhagenstedt.removeLoanButton.enabled = true;
			bankofhagenstedt.removeFiveThousandButton.enabled = true;
		else
			bankofhagenstedt.removeLoanButton.enabled = false;
			bankofhagenstedt.removeFiveThousandButton.enabled = false;
		end;
	else
		bankofhagenstedt.addLoanButton.enabled = true;	
		bankofhagenstedt.removeLoanButton.enabled = false;
	end;
	--Money > 5000 und Loan >= 5000 ==> Rckzahlung in 5000
	if((g_currentMission.missionStats.money>bankofhagenstedt.giantsLoanInterval) and (g_currentMission.missionStats.loan>=bankofhagenstedt.giantsLoanInterval)) then
		bankofhagenstedt.removeFiveThousandButton.enabled = true;
	else
		bankofhagenstedt.removeFiveThousandButton.enabled = false;
	end;

end;
function bankofhagenstedt:getCurrentInterestAmount()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - getCurrentInterestAmount()");
	end;	
	local zinsatz = g_currentMission.missionStats.loanAnnualInterestRate;
	--Wenn Kredit ueberhaupt aufgenommen
	local interestValue = 0;
	if (bankofhagenstedt.activeLoanValue>0) then
		interestValue = bankofhagenstedt.activeLoanValue* (zinsatz/bankofhagenstedt.giantsLoanInterestCalculationDays);
	end;
	
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - interestValue:" .. interestValue);
	end;
	return math.ceil(interestValue);
end;
function bankofhagenstedt:addFiveThousand()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - addFiveThousand()");
	end;
	local freeMaxLoan = g_currentMission.missionStats.loanMax - g_currentMission.missionStats.loan;
	if(freeMaxLoan>=bankofhagenstedt.giantsLoanInterval) then
		g_currentMission.missionStats.loan = g_currentMission.missionStats.loan + bankofhagenstedt.giantsLoanInterval;
		g_currentMission:addSharedMoney(bankofhagenstedt.giantsLoanInterval);
		self:setInfo(g_i18n:getText("BOH_LOANBORROWEDFIVETHOUSAND"));	
	else
		self:setInfo(g_i18n:getText("BOH_BANKLINEINSUFFICIENT"));	
	end;
end;
function bankofhagenstedt:removeFiveThousand()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - removeFiveThousand()");
	end;
	--Wenn Money > 5000
	if(g_currentMission.missionStats.money>bankofhagenstedt.giantsLoanInterval) then
		--Wenn eigener Kredit Active dann diesen tilgen
		if(bankofhagenstedt.loanActive) then
			--Wenn active loan > 5000 dann abbezahlen.
			if(bankofhagenstedt.activeLoanValue>bankofhagenstedt.giantsLoanInterval) then
				g_currentMission:addSharedMoney(-bankofhagenstedt.giantsLoanInterval);
				g_currentMission.missionStats.loan = g_currentMission.missionStats.loan - bankofhagenstedt.giantsLoanInterval;
				bankofhagenstedt.activeLoanValue = bankofhagenstedt.activeLoanValue - bankofhagenstedt.giantsLoanInterval;
				self:setInfo(g_i18n:getText("BOH_LOANREPAYEDFIVETHOUSAND"));
			else
				--Wenn active loan < 5000 dann teil bezahlen und rest vom normalen kredit zahlen
				g_currentMission:addSharedMoney(-bankofhagenstedt.giantsLoanInterval);
				g_currentMission.missionStats.loan = g_currentMission.missionStats.loan - bankofhagenstedt.giantsLoanInterval;
				self:resetLoan();
				self:setInfo(g_i18n:getText("BOH_LOANREPAYEDFIVETHOUSAND"));	
			end;
		else
			-- loan nicht aktiv dann nur loan abziehen.
			if(g_currentMission.missionStats.loan>bankofhagenstedt.giantsLoanInterval) then
				--loan >= 5000, dann 5000 tilgen.
				g_currentMission:addSharedMoney(-bankofhagenstedt.giantsLoanInterval);
				g_currentMission.missionStats.loan = g_currentMission.missionStats.loan - bankofhagenstedt.giantsLoanInterval;
				self:setInfo(g_i18n:getText("BOH_LOANREPAYEDFIVETHOUSAND"));	
			else
				-- loan < 5000, dann rest tilgen.
				g_currentMission:addSharedMoney(-g_currentMission.missionStats.loan);
				g_currentMission.missionStats.loan = 0;
				bankofhagenstedt.removeFiveThousandButton.enabled = false;
				bankofhagenstedt.removeLoanButton.enabled = false;				
				self:setInfo(g_i18n:getText("BOH_LOANREPAYEDFIVETHOUSAND"));	
			end;
		end;
	else
				self:setInfo(g_i18n:getText("BOH_MONEYINSUFFICIENT"));			
	end;
end;
function bankofhagenstedt:saveBankData()
	if(bankofhagenstedt.debug) then
		print("Bankofhagenstedt - DEBUG - saveBankData()");
	end;
    local xmlFile = createXMLFile("bankofhagenstedt", bankofhagenstedt.savegameFilename, bankofhagenstedt.scriptName);
	if (xmlFile ~= nil) then
		setXMLFloat( xmlFile, bankofhagenstedt.scriptName.."#version", bankofhagenstedt.version);
		setXMLString( xmlFile, bankofhagenstedt.scriptName.."#author", "MX11");
		--
		local tag = bankofhagenstedt.scriptName..".missionStats";
		setXMLFloat(xmlFile, tag.."#money", Utils.getNoNil(g_currentMission.missionStats.money, 0));
		setXMLFloat(xmlFile, tag.."#loan", Utils.getNoNil(g_currentMission.missionStats.loan, 0));
		setXMLFloat(xmlFile, tag.."#loanMax", Utils.getNoNil(g_currentMission.missionStats.loanMax, 0));
		setXMLFloat(xmlFile, tag.."#loanAnnualInterestRate", Utils.getNoNil(g_currentMission.missionStats.loanAnnualInterestRate, 0));
		tag = bankofhagenstedt.scriptName..".activeLoanStats";
		setXMLFloat(xmlFile, tag.."#activeLoanValue", Utils.getNoNil(bankofhagenstedt.activeLoanValue, 0));
		setXMLFloat(xmlFile, tag.."#activeLoanInterestOwed", Utils.getNoNil(bankofhagenstedt.activeLoanInterestOwed, 0));
		setXMLFloat(xmlFile, tag.."#activeLoanDays", Utils.getNoNil(bankofhagenstedt.activeLoanDays, 0));
		setXMLFloat(xmlFile, tag.."#activeLoanPeriod", Utils.getNoNil(bankofhagenstedt.activeLoanPeriod, 0));
		setXMLFloat(xmlFile, tag.."#activeLoanOverdraftDays", Utils.getNoNil(bankofhagenstedt.activeLoanOverdraftDays, 0));
		setXMLFloat(xmlFile, tag.."#activeLoanOverdraftInterest", Utils.getNoNil(bankofhagenstedt.activeLoanOverdraftInterest, 0));
		tag = bankofhagenstedt.scriptName..".newLoanStats";
		setXMLFloat(xmlFile, tag.."#loanValue", Utils.getNoNil(bankofhagenstedt.loanValue, 0));
		setXMLFloat(xmlFile, tag.."#loanFees", Utils.getNoNil(bankofhagenstedt.loanFees, 0));
		setXMLFloat(xmlFile, tag.."#loanPeriod", Utils.getNoNil(bankofhagenstedt.loanPeriod, 0));
		setXMLFloat(xmlFile, tag.."#loanOverdraftDays", Utils.getNoNil(bankofhagenstedt.loanOverdraftDays, 0));
		setXMLFloat(xmlFile, tag.."#loanOverdraftInterest", Utils.getNoNil(bankofhagenstedt.loanOverdraftInterest, 0));
		tag = bankofhagenstedt.scriptName..".beforeLoanStats";
		setXMLFloat(xmlFile, tag.."#beforeLoan", Utils.getNoNil(bankofhagenstedt.beforeLoanValue, 0));
		setXMLFloat(xmlFile, tag.."#beforeLoanMax", Utils.getNoNil(bankofhagenstedt.beforeLoanMax, 0));
		setXMLFloat(xmlFile, tag.."#beforeLoanAnnualInterestRate", Utils.getNoNil(bankofhagenstedt.beforeLoanInterestRate, 0));
		--
		saveXMLFile(xmlFile);
        self:setInfo(g_i18n:getText("BOH_SAVESUCCESS"));
		delete(xmlFile);
	else
		if(bankofhagenstedt.debug) then
			print("Bankofhagenstedt - DEBUG - bankofhagenstedt Failed to save '".. bankofhagenstedt.savegameFilename .."' xmlFile=nil.");
		end;
		self:setWarning(g_i18n:getText("BOH_SAVEFAILED"));
	end;		
end;
function bankofhagenstedt:loadBankData(firstTimeLoad)
	--Vielen Dank an rafftnix fr den Tipp mit getFiles und dem Callback!
	--Pruefen ob Datei vorhanden ist.
	getFiles(self.savegamePath, "getFilesCallback", self);	
	if self.fileFound then

		local xmlFile = loadXMLFile(bankofhagenstedt.scriptName.."xml", bankofhagenstedt.savegameFilename);
		if (xmlFile ~= nil) then
			local version = getXMLFloat(xmlFile, bankofhagenstedt.scriptName.."#version");
			version = math.floor(version*1000)/1000;
			if (version <= bankofhagenstedt.version) then
				local tag = bankofhagenstedt.scriptName..".missionStats";
				bankofhagenstedt.lastMoney = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#money"), 0);
				g_currentMission.missionStats.money = bankofhagenstedt.lastMoney;
				g_currentMission.missionStats.loan = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loan"), 0);
				g_currentMission.missionStats.loanMax = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanMax"), 0);
				g_currentMission.missionStats.loanAnnualInterestRate = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanAnnualInterestRate"), 0);
				tag = bankofhagenstedt.scriptName..".activeLoanStats";	
				bankofhagenstedt.activeLoanValue = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#activeLoanValue"), 0);
				bankofhagenstedt.activeLoanInterestOwed = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#activeLoanInterestOwed"), 0);
				bankofhagenstedt.activeLoanDays = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#activeLoanDays"), 0);
				bankofhagenstedt.activeLoanPeriod = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#activeLoanPeriod"), 0);
				bankofhagenstedt.activeLoanOverdraftDays = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#activeLoanOverdraftDays"), 0);
				bankofhagenstedt.activeLoanOverdraftInterest = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#activeLoanOverdraftInterest"), 0);
				tag = bankofhagenstedt.scriptName..".newLoanStats";
				bankofhagenstedt.loanValue = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanValue"), 0);
				bankofhagenstedt.loanFees = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanFees"), 0);
				bankofhagenstedt.loanPeriod = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanPeriod"), 0);
				bankofhagenstedt.loanOverdraftDays = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanOverdraftDays"), 0);
				bankofhagenstedt.loanOverdraftInterest = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#loanOverdraftInterest"), 0);
				tag = bankofhagenstedt.scriptName..".beforeLoanStats";
				bankofhagenstedt.beforeLoanValue = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#beforeLoan"), 0);
				bankofhagenstedt.beforeLoanMax = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#beforeLoanMax"), 0);
				bankofhagenstedt.beforeLoanInterestRate = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#beforeLoanAnnualInterestRate"), 0);
				
				self.firstRun = true;
				if(bankofhagenstedt.debug) then
					print("Bankofhagenstedt - DEBUG - loanAnnualInterestRate:" .. g_currentMission.missionStats.loanAnnualInterestRate);
					print("Bankofhagenstedt - DEBUG - loanMax:" .. g_currentMission.missionStats.loanMax);
					print("Bankofhagenstedt - DEBUG - loan:" .. g_currentMission.missionStats.loan);
					print("Bankofhagenstedt - DEBUG - money:" .. g_currentMission.missionStats.money);
					print("Bankofhagenstedt - DEBUG - activeLoanValue:" .. self.activeLoanValue);
					print("Bankofhagenstedt - DEBUG - activeLoanInterestOwed:" .. self.activeLoanInterestOwed);
					print("Bankofhagenstedt - DEBUG - loanValue:" .. self.loanValue);
					print("Bankofhagenstedt - DEBUG - " .. g_i18n:getText("BOH_LOADSUCCESS"));
				end;
				if(bankofhagenstedt.activeLoanValue>0) then
					bankofhagenstedt.loanActive = true;
				end;
				if(firstTimeLoad==false) then
					self:setInfo(g_i18n:getText("BOH_LOADSUCCESS"));
				end;
			else
				if(bankofhagenstedt.debug) then
					print("Bankofhagenstedt - DEBUG - " .. g_i18n:getText("BOH_LOADFAILED") .. " '".. bankofhagenstedt.savegameFilename .."', version='".. Utils.getNoNil(version, "nil") .."'. Expected '".. bankofhagenstedt.version .."'.");
				end;
				self:setWarning(g_i18n:getText("BOH_LOADFILEWRONGVERSION"));
			end;
			
			delete(xmlFile);
		else
			if(bankofhagenstedt.debug) then
				print("Bankofhagenstedt - DEBUG - " .. g_i18n:getText("BOH_LOADFAILED") .. " '".. bankofhagenstedt.savegameFilename .."' xmlFile=nil.");
			end;
			self:setInfo(g_i18n:getText("BOH_LOADFAILED"));
		end;
	else
		if(bankofhagenstedt.debug) then
			print("Bankofhagenstedt - DEBUG - loadBankData() - " .. g_i18n:getText("BOH_LOADFILENOTFOUND"));
		end;
		self:setInfo(g_i18n:getText("BOH_LOADFILENOTFOUND"));
	end;
end;
function bankofhagenstedt:getFilesCallback(filename)
	if filename == "bankofhagenstedt.xml" then
		self.fileFound = true;
	end;
end;



addModEventListener(bankofhagenstedt);