-- LS13Money(original: SrsMoney)
-- by hummel (modhoster)

LS13Money = {};

function LS13Money:loadMap(name)
  self.money_amount = 0;
end;

function LS13Money:keyEvent(unicode, sym, modifier, isDown)
  if bitAND(modifier, Input.MOD_ALT) > 0 and bitAND(modifier, Input.MOD_CTRL) > 0 then
    if InputBinding.isPressed(InputBinding.HONK) then
      self.money_amount = 1000000;
    end
    
    if InputBinding.isPressed(InputBinding.TOGGLE_BEACON_LIGHTS) then
      self.money_amount = -1000000;
    end

    if self.money_amount ~= 0 and g_server == nil then
      g_client:getServerConnection():sendEvent(LS13MoneyEvent:new(self));
    end;
  end;		
end;

function LS13Money:update(dt)
  if self.money_amount ~= 0 and g_server ~= nil then 
    g_currentMission:addSharedMoney(self.money_amount);
    self.money_amount = 0;
  end;
end;

function LS13Money:draw()
end;

function LS13Money:deleteMap()
end;

function LS13Money:mouseEvent(posX, posY, isDown, isUp, button)
end;

addModEventListener(LS13Money);

LS13MoneyEvent = {};
LS13MoneyEvent_mt = Class(LS13MoneyEvent, Event);

InitEventClass(LS13MoneyEvent, "LS13MoneyEvent");

function LS13MoneyEvent:readStream(streamId, connection)
  self.object = LS13Money;
  self.object.money_amount = streamReadInt32(streamId);
end;

function LS13MoneyEvent:writeStream(streamId, connection)
  streamWriteInt32(streamId, self.object.money_amount);
end;

function LS13MoneyEvent:new(object)
  local self = LS13MoneyEvent:emptyNew()
  self.object = object;
  return self;
end;

function LS13MoneyEvent:emptyNew()
  local self = Event:new(LS13MoneyEvent_mt);
  self.className="LS13MoneyEvent";
  return self;
end;
